#ifndef GST_GEOMETRY_GEOMETRY_STRUCTS_HPP__
#define GST_GEOMETRY_GEOMETRY_STRUCTS_HPP__

#include "buildspec.h"

#include <map>
#include <string>
#include <vector>

#include <boost/shared_ptr.hpp>

namespace GST
{
namespace Geometry
{
// Case for how to deal with lines that have coordinates outside the location
// line extent
enum class GeologicalProfileLineCheckKind
{
	// lines will be scaled to the location line
	AbsoluteScale,
	// error if line extent greater than margin of error
	// lines will be cutoff at the extent of the location line
	CutoffWithMarginOfError
};

// Describes how to deal with lines that have coordinates outside the location
// line extent
struct GST_API_EXPORT GeologicalProfileLineCheck
{
	GeologicalProfileLineCheckKind kind
		= GeologicalProfileLineCheckKind::AbsoluteScale;
	double marginOfError = 0;
};

// Required settings to upload geological profiles
struct GST_API_EXPORT GeologicalProfileSettings
{
	// location line kind name
	std::string locationLineKindName;
	// the index of the location line feature to use
	uint64_t locationLineIndex = 0;
	// subgeometry kind => attribute matching
	std::map<std::string, std::vector<std::pair<std::string, int64_t>>> attrs;
	// subgeometry kind => (full) file path
	// note: mustn't contain location line, that is transported in the feature
	std::map<std::string, std::string> files;
	// how to deal with lines that have coordinates outside the location line
	// extent
	GeologicalProfileLineCheck lineCheck;
	// exaggeration in the profile height, will be calculated out on import
	double exaggeration = 1.0;
};
using GeologicalProfileSettingsPtr
	= boost::shared_ptr<GeologicalProfileSettings>;
} // namespace Geometry
} // namespace GST
#endif // GST_GEOMETRY_GEOMETRY_STRUCTS_HPP__
